/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _CALIBRATIONSTOREDCALIBRATIONISVALIDCOMMAND_H_
#define _CALIBRATIONSTOREDCALIBRATIONISVALIDCOMMAND_H_

#include "ICommand.h"

class CalibrationStoredCalibrationIsValidCommand : public ICommand
{
public:
    /*!
     * \action    This command returns whether the calibration is valid
     * \frequency
     * \param[in] sender process id of application that sent this command
     * \param[in] deviceName Name of the input device
     * \param[out] valid contains the result of the function
     * \ingroup Commands
     */
    CalibrationStoredCalibrationIsValidCommand(pid_t sender,
                                               const std::string& deviceName,
                                               bool* valid)
    : ICommand(ExecuteSynchronous, sender)
    , m_deviceName(deviceName)
    , m_valid(valid)
    {}

    /**
     * \brief default destructor
     */
    virtual ~CalibrationStoredCalibrationIsValidCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement Commands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionFailed: execution failed
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    const std::string& m_deviceName;
    bool* m_valid;
};

#endif // _CALIBRATIONSTOREDCALIBRATIONISVALIDCOMMAND_H_
